<?php

/**
 * Test class ModelRest Response Object Factory
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelRest\Response\Object;

use GuzzleHttp\Client;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;
use Sso\RestBundle\Api;
use Sso\RestBundle\ModelRest;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Test class ModelRest Response Object Factory
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class FactoryTest extends WebTestCase
{

    /**
     *
     * @var Api\Manager
     */
    public $apiM;

    /**
     *
     * @var Client
     */
    protected $client;

    /**
     *
     * @var ContainerInterface
     */
    protected $container;

    protected function setUp()
    {
        $this->client = static::createClient();
        $this->container = $this->client->getContainer();
        $this->apiM = new Api\Manager($this->container);
    }

    public function testGetFactory()
    {
        // asserts
        $this->assertInstanceOf('\Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\Object\Show\Factory',
            $this->apiM->modelRest()->response()->objectWs()->version1()->object()->show());
    }

    public function testPutFactory()
    {
        // asserts
        $this->assertInstanceOf('\Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\Object\Add\Factory',
            $this->apiM->modelRest()->response()->objectWs()->version1()->object()->add());
    }
}
