<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelRest\Response\ObjectWs\Version1\ObjectValue;

use PHPUnit\Framework\TestCase;
use Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\ObjectValue\Factory;
use Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\ObjectValue\Add\Factory as FactoryAdd;
use Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\ObjectValue\Show\Factory as FactoryShow;
use Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\ObjectValue\Delete\Factory as FactoryDelete;
use Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\ObjectValue\Update\Factory as FactoryUpdate;

/**
 * Class FactoryTest
 * @package Sso\RestBundle\Tests\ModelRest\Response\ObjectWs\Version1\ObjectValue
 */
class FactoryTest extends TestCase
{
    /**
     * @var Factory
     */
    private $factory;

    protected function setUp()
    {
        $this->factory = new Factory();
    }

    public function testAddFactory()
    {
        $this->assertInstanceOf(FactoryAdd::class, $this->factory->add());
    }

    public function testShowFactory()
    {
        $this->assertInstanceOf(FactoryShow::class, $this->factory->show());
    }

    public function testDeleteFactory()
    {
        $this->assertInstanceOf(FactoryDelete::class, $this->factory->delete());
    }

    public function testUpdateFactory()
    {
        $this->assertInstanceOf(FactoryUpdate::class, $this->factory->update());
    }
}
