<?php

/**
 * Class FactoryTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelRest\Response\UserWs\Version1\UserService\ActivateConfirm;


use Sso\RestBundle\ModelRest\Common\Response\UserWs\ErrorCollector\Error;
use Sso\RestBundle\ModelRest\Response\UserWs\Version1\UserService\ActivateConfirm;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

/**
 * Class FactoryTest
 * @package Sso\RestBundle\Tests\ModelRest\Response\UserWs\Version1\UserService\ActivateConfirm
 */
class FactoryTest extends WebTestCase
{
    /**
     * @var ActivateConfirm\Factory
     */
    private $factory;

    /**
     * {@inheritDoc}
     */
    public function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->factory = new ActivateConfirm\Factory();
    }

    public function testResponseFactory()
    {
        static::assertInstanceOf(ActivateConfirm\Response::class, $this->factory->response());
    }

    public function testUserTypeFactory()
    {
        static::assertInstanceOf(ActivateConfirm\UserType::class, $this->factory->userType());
    }

    public function testErrorFactory()
    {
        static::assertInstanceOf(Error::class, $this->factory->error());
    }
}
