<?php

/**
 * Class FactoryTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelRest\Response\UserWs\Version1\UserService\ActivateRequest;


use Sso\RestBundle\ModelRest\Common\Response\UserWs\ErrorCollector\Error;
use Sso\RestBundle\ModelRest\Response\UserWs\Version1\UserService\ActivateRequest;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

/**
 * Class FactoryTest
 * @package Sso\RestBundle\Tests\ModelRest\Response\UserWs\Version1\UserApplication
 */
class FactoryTest extends WebTestCase
{
    /**
     * @var ActivateRequest\Factory
     */
    private $factory;

    /**
     * {@inheritDoc}
     */
    public function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->factory = new ActivateRequest\Factory();
    }

    public function testResponseFactory()
    {
        static::assertInstanceOf(ActivateRequest\Response::class, $this->factory->response());
    }

    public function testUserTypeFactory()
    {
        static::assertInstanceOf(ActivateRequest\UserType::class, $this->factory->userType());
    }

    public function testErrorFactory()
    {
        static::assertInstanceOf(Error::class, $this->factory->error());
    }
}
