<?php

/**
 * Class FactoryTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelRest\Response\UserWs\Version2\UserApplicationRole\Show;

use Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserApplicationRole\Show;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

/**
 * Class FactoryTest
 * @package Sso\RestBundle\Tests\ModelRest\Response\UserWs\Version2\UserApplicationRole
 */
class FactoryTest extends WebTestCase
{
    /**
     * @var Show\Factory
     */
    private $factory;

    /**
     * {@inheritDoc}
     */
    public function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->factory = new Show\Factory();
    }

    public function testResponseFactory()
    {
        static::assertInstanceOf(Show\Response::class, $this->factory->response());
    }

    public function testApplicationTypeFactory()
    {
        static::assertInstanceOf(Show\ApplicationType::class, $this->factory->applicationType());
    }

    public function testUserTypeFactory()
    {
        static::assertInstanceOf(Show\UserType::class, $this->factory->userType());
    }

    public function testRoleTypeFactory()
    {
        static::assertInstanceOf(Show\RoleType::class, $this->factory->roleType());
    }

    public function testErrorFactory()
    {
        static::assertInstanceOf(Show\Error::class, $this->factory->error());
    }
}
