<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelRest\Response\UserWs\Version2\UserSearch\Advanced;

use PHPUnit\Framework\TestCase;
use Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserSearch\Advanced as RestResponse;
use Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserSearch\Advanced\Factory as ResponseFactory;
use Sso\RestBundle\ModelRest\Common\Response\UserWs\ErrorCollector;

/**
 * Class FactoryTest
 * @package Sso\RestBundle\Tests\ModelRest\Response\UserWs\Version2\UserSearch\Advanced
 */
class FactoryTest extends TestCase
{
    /**
     * @var ResponseFactory
     */
    private $factory;

    public function setUp()
    {
        $this->factory = new ResponseFactory();
        parent::setUp();
    }

    public function testError()
    {
        $this->assertInstanceOf(ErrorCollector\Error::class, $this->factory->error());
    }

    public function testResponse()
    {
        $this->assertInstanceOf(RestResponse\Response::class, $this->factory->response());
    }
}
