<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelXml\Request\ObjectWs\Version1\AttributeGroup\Add;

use Sso\RestBundle\ModelXml\Common\Request\Credentials\ObjectWs\Credentials;
use Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\AttributeGroup\Add\Request;
use Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\AttributeGroup\Add\AttributeGroup;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;
use Sso\RestBundle\Api\Manager as ApiManager;
use JMS\Serializer\SerializerInterface;
use Faker\Factory as FakerFactory;
use Faker\Generator as FakerGenerator;

/**
 * Class RequestTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\RestBundle\Tests\ModelRest
 */
class RequestTest extends WebTestCase
{
    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @var ApiManager
     */
    private $apiManager;

    /**
     * @var FakerGenerator
     */
    private $faker;

    /**
     * @var string
     */
    private $serviceToken;

    /**
     * @var string
     */
    private $serviceName;

    /**
     * @var string
     */
    private $userIdentifier;

    /**
     * @var string
     */
    private $username;

    /**
     * @var string
     */
    private $langCode;

    /**
     * @var string
     */
    private $id;

    /**
     * @var string
     */
    private $id2;

    /**
     * @var string
     */
    private $name;

    protected function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->apiManager = new ApiManager(static::$kernel->getContainer());
        $this->serializer = $this->apiManager->serializer();
        $this->faker = FakerFactory::create();

        // Set same random data
        $this->serviceToken = $this->faker->sha256;
        $this->serviceName = $this->faker->word;
        $this->userIdentifier = $this->faker->md5;
        $this->username = $this->faker->userName;
        $this->langCode = $this->faker->languageCode;
        $this->id = $this->faker->sha1;
        $this->id2 = $this->faker->sha1;
        $this->name = $this->faker->name;
    }

    public function testSerialize()
    {
        $this->assertXmlStringEqualsXmlString($this->getRequestBody(), $this->setRequestBody());
    }

    /**
     * @return string
     */
    private function setRequestBody()
    {
        $request = new Request();
        $credentials = new Credentials();
        $attributeGroup = new AttributeGroup();

        $credentials->setCredentialsData(
            $this->serviceToken,
            $this->serviceName,
            $this->userIdentifier,
            $this->username,
            $this->langCode
        );

        $attributeGroup->setAttributeGroup(
            $this->name,
            new ArrayCollection([$this->id, $this->id2])
        );

        $request->setCredentials($credentials);
        $request->setAttributeGroup($attributeGroup);

        return $this->serializer->serialize($request, 'xml');
    }

    /**
     * @return string
     */
    private function getRequestBody()
    {
        return '<SsoRequest>
            <Credentials>
                <ServiceProvider>
                    <ServiceToken><![CDATA[' . $this->serviceToken . ']]></ServiceToken>
                    <ServiceName><![CDATA[' . $this->serviceName . ']]></ServiceName>
                </ServiceProvider>
                <ServiceTrigger>
                    <UserIdentifier><![CDATA[' . $this->userIdentifier . ']]></UserIdentifier>
                    <Username><![CDATA[' . $this->username . ']]></Username>
                </ServiceTrigger>
                <ServiceCountry>
                    <Code><![CDATA[' . $this->langCode . ']]></Code>
                </ServiceCountry>
            </Credentials>
            <AttributeGroup>
                <Add>
                    <AttributeGroupType>
                        <Name><![CDATA[' . $this->name . ']]></Name>
                        <Types>
                            <Type>
                                <Id><![CDATA[' . $this->id . ']]></Id>
                            </Type>
                            <Type>
                                <Id><![CDATA[' . $this->id2 . ']]></Id>
                            </Type>
                        </Types>
                    </AttributeGroupType>
                </Add>
            </AttributeGroup>
        </SsoRequest>';
    }

    public function testGetters()
    {
        /** @var  Request $requestModel */
        $requestModel = $this->serializer->deserialize(
            $this->setRequestBody(),
            Request::class,
            'xml'
        );

        $attributeGroupType = $requestModel->getAttributeGroup()->getAdd()->getAttributeGroupType();
        $type = $attributeGroupType->getTypes()->get(0);

        $credentials = $requestModel->getCredentials();

        $this->assertEquals($this->name, $attributeGroupType->getName());
        $this->assertEquals($this->id, $type->getId());
        $this->assertEquals($this->serviceToken, $credentials->getServiceProvider()->getServiceToken());
    }
}
