<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelXml\Request\ObjectWs\Version1\Object\Add;

use Sso\RestBundle\ModelXml\Common\Request\Credentials\ObjectWs\Credentials;
use Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Object\Add\Add;
use Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Object\Add\Factory;
use Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Object\Add\Request;
use Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Object\Add\Object;
use Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Object\Add\ObjectType;
use PHPUnit\Framework\TestCase;

/**
 * Class FactoryTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class FactoryTest extends TestCase
{
    /**
     * @var Factory
     */
    private $factory;

    protected function setUp()
    {
        $this->factory = new Factory();
    }

    public function testRequest()
    {
        $this->assertInstanceOf(Request::class, $this->factory->request());
    }

    public function testAdd()
    {
        $this->assertInstanceOf(Add::class, $this->factory->add());
    }

    public function testCredentials()
    {
        $this->assertInstanceOf(Credentials::class, $this->factory->credentials());
    }

    public function testObject()
    {
        $this->assertInstanceOf(Object::class, $this->factory->object());
    }

    public function testObjectType()
    {
        $this->assertInstanceOf(ObjectType::class, $this->factory->objectType());
    }
}
