<?php

/**
 * Class FactoryTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelXml\Request\UserWs\Version1\UserApplicationRole\Add;

use Sso\RestBundle\ModelXml\Common\Request\Credentials\UserWs\Credentials;
use Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplicationRole\Add;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

/**
 * Class FactoryTest
 * @package Sso\RestBundle\Tests\ModelXml\Request\UserWs\Version1\UserApplicationRole\Add
 */
class FactoryTest extends WebTestCase
{
    /**
     * @var Add\Factory
     */
    private $factory;

    /**
     * {@inheritDoc}
     */
    public function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->factory = new Add\Factory();
    }

    public function testRequestFactory()
    {
        static::assertInstanceOf(Add\Request::class, $this->factory->request());
    }

    public function testCredentialsFactory()
    {
        static::assertInstanceOf(Credentials::class, $this->factory->credentials());
    }

    public function testAddFactory()
    {
        static::assertInstanceOf(Add\Add::class, $this->factory->add());
    }

    public function testKeyFactory()
    {
        static::assertInstanceOf(Add\Key::class, $this->factory->key());
    }

    public function testValueFactory()
    {
        static::assertInstanceOf(Add\Value::class, $this->factory->value());
    }

    public function testUserApplicationRoleFactory()
    {
        static::assertInstanceOf(Add\UserApplicationRole::class, $this->factory->userApplicationRole());
    }

    public function testUserTypeFactory()
    {
        static::assertInstanceOf(Add\UserType::class, $this->factory->userType());
    }

    public function testApplicationTypeFactory()
    {
        static::assertInstanceOf(Add\ApplicationType::class, $this->factory->applicationType());
    }

    public function testRoleTypeFactory()
    {
        static::assertInstanceOf(Add\RoleType::class, $this->factory->roleType());
    }
}