<?php

/**
 * Class RequestTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelXml\Request\UserWs\Version1\UserApplicationRole\Add;

use Sso\RestBundle\Api\Manager as ApiManager;
use Sso\RestBundle\ModelXml\Common\Request\Credentials\UserWs\Credentials;
use Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplicationRole\Add;
use Faker\Factory as FakerFactory;
use Faker\Generator as FakerGenerator;
use JMS\Serializer\SerializerInterface;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

/**
 * Class RequestTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\RestBundle\Tests\ModelXml\Request\UserWs\Version1\UserApplicationRole\Add
 */
class RequestTest extends WebTestCase
{
    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @var ApiManager
     */
    private $apiManager;

    /**
     * @var FakerGenerator
     */
    private $faker;

    /**
     * @var Add\Request
     */
    private $request;

    protected function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->apiManager = new ApiManager(static::$kernel->getContainer());
        $this->serializer = $this->apiManager->serializer();
        $this->faker = FakerFactory::create();

        $this->setUpRequest();
    }

    private function setUpRequest()
    {
        $request = new Add\Request();
        $credentials = new Credentials();
        $userApplicationRole = new Add\UserApplicationRole();

        $credentials->setCredentialsData($this->faker->uuid, $this->faker->name, $this->faker->userName,
            $this->faker->userName, $this->faker->text);
        $request->setCredentials($credentials)
            ->setUserApplicationRole($userApplicationRole);
        $userApplicationRole->setUserApplicationRoleTypeData($this->faker->userName, $this->faker->name,
            $this->faker->name, $this->faker->numberBetween(0, 1));

        $this->request = $request;
    }

    public function testGetAndSetCredentials()
    {
        $request = new Add\Request();
        $credentials = new Credentials();

        $request->setCredentials($credentials);

        static::assertEquals($request->getCredentials(), $credentials);
    }

    public function testGetAndSetUserApplicationRole()
    {
        $request = new Add\Request();
        $userApplicationRole = new Add\UserApplicationRole();

        $request->setUserApplicationRole($userApplicationRole);

        static::assertEquals($request->getUserApplicationRole(), $userApplicationRole);
    }

    public function testXMLSerialize()
    {
        static::assertXmlStringEqualsXmlString($this->serializer->serialize($this->request, 'xml'),
            $this->getExpectedResponseContent());
    }

    /**
     * @return string
     */
    private function getExpectedResponseContent()
    {
        return <<< XML
<?xml version="1.0" encoding="UTF-8"?>
<SsoRequest>
    <Credentials>
        <ServiceProvider>
            <ServiceToken><![CDATA[{$this->request->getCredentials()->getServiceProvider()->getServiceToken()}]]></ServiceToken>
            <ServiceName><![CDATA[{$this->request->getCredentials()->getServiceProvider()->getServiceName()}]]></ServiceName>
        </ServiceProvider>
        <ServiceTrigger>
            <UserIdentifier><![CDATA[{$this->request->getCredentials()->getServiceTrigger()->getUserIdentifier()}]]></UserIdentifier>
            <Username><![CDATA[{$this->request->getCredentials()->getServiceTrigger()->getUsername()}]]></Username>
        </ServiceTrigger>
        <ServiceCountry>
            <Code>{$this->request->getCredentials()->getServiceCountry()->getCode()}</Code>
        </ServiceCountry>
    </Credentials>
    <UserApplicationRole>
        <Add>
            <Key>
                <UserType>
                    <Identifier><![CDATA[{$this->request->getUserApplicationRole()->getAdd()->getKey()->getUserType()->getIdentifier()}]]></Identifier>
                </UserType>
                <ApplicationType>
                    <Name><![CDATA[{$this->request->getUserApplicationRole()->getAdd()->getKey()->getApplicationType()->getName()}]]></Name>
                </ApplicationType>
            </Key>
            <Value>
                <RoleType>
                    <Name><![CDATA[{$this->request->getUserApplicationRole()->getAdd()->getValue()->getRoleType()->getName()}]]></Name>
                    <Active>{$this->request->getUserApplicationRole()->getAdd()->getValue()->getRoleType()->getActive()}</Active>
                </RoleType>
            </Value>
        </Add>
    </UserApplicationRole>
</SsoRequest>
XML;
    }
}