<?php

/**
 * Class FactoryTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelXml\Request\UserWs\Version1\UserApplicationRole\Delete;

use Sso\RestBundle\ModelXml\Common\Request\Credentials\UserWs\Credentials;
use Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplicationRole\Delete;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

/**
 * Class FactoryTest
 * @package Sso\RestBundle\Tests\ModelXml\Request\UserWs\Version1\UserApplication\Delete
 */
class FactoryTest extends WebTestCase
{
    /**
     * @var Delete\Factory
     */
    private $factory;

    /**
     * {@inheritDoc}
     */
    public function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->factory = new Delete\Factory();
    }

    public function testRequestFactory()
    {
        static::assertInstanceOf(Delete\Request::class, $this->factory->request());
    }

    public function testCredentialsFactory()
    {
        static::assertInstanceOf(Credentials::class, $this->factory->credentials());
    }

    public function testDeleteFactory()
    {
        static::assertInstanceOf(Delete\Delete::class, $this->factory->delete());
    }

    public function testUserApplicationRoleFactory()
    {
        static::assertInstanceOf(Delete\UserApplicationRole::class, $this->factory->userApplicationRole());
    }

    public function testUserTypeFactory()
    {
        static::assertInstanceOf(Delete\UserType::class, $this->factory->userType());
    }

    public function testApplicationTypeFactory()
    {
        static::assertInstanceOf(Delete\ApplicationType::class, $this->factory->applicationType());
    }
}