<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelXml\Request\UserWs\Version1\UserService\PasswordRequest;

use Sso\RestBundle\ModelXml\Common\Request\Credentials\UserWs\Credentials;
use Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserService\PasswordRequest\Request;
use Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserService\PasswordRequest\UserService;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;
use Sso\RestBundle\Api\Manager as ApiManager;
use JMS\Serializer\SerializerInterface;
use Faker\Factory as FakerFactory;
use Faker\Generator as FakerGenerator;

/**
 * Class RequestTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\RestBundle\Tests\ModelRest
 */
class RequestTest extends WebTestCase
{
    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @var ApiManager
     */
    private $apiManager;

    /**
     * @var FakerGenerator
     */
    private $faker;

    /**
     * @var string
     */
    private $serviceToken;

    /**
     * @var string
     */
    private $serviceName;

    /**
     * @var string
     */
    private $userIdentifier;

    /**
     * @var string
     */
    private $username;

    /**
     * @var string
     */
    private $langCode;

    /**
     * @var string
     */
    private $identifier;

    /**
     * @var string
     */
    private $name;

    /**
     * @var string
     */
    private $active;

    protected function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->apiManager = new ApiManager(static::$kernel->getContainer());
        $this->serializer = $this->apiManager->serializer();
        $this->faker = FakerFactory::create();

        // Set same random data
        $this->serviceToken = $this->faker->sha256;
        $this->serviceName = $this->faker->word;
        $this->userIdentifier = $this->faker->md5;
        $this->username = $this->faker->userName;
        $this->langCode = $this->faker->languageCode;
        $this->identifier = $this->faker->email;
        $this->name = $this->faker->name;
        $this->active = $this->faker->boolean ? 1 : 0;
    }

    public function testSerialize()
    {
        $this->assertXmlStringEqualsXmlString($this->getRequestBody(), $this->setRequestBody());
    }

    /**
     * @return string
     */
    private function setRequestBody()
    {
        $request = new Request();
        $credentials = new Credentials();
        $userService = new UserService();

        $credentials->setCredentialsData(
            $this->serviceToken,
            $this->serviceName,
            $this->userIdentifier,
            $this->username,
            $this->langCode
        );

        $userService->setUserService(
            $this->identifier
        );

        $request->setCredentials($credentials);
        $request->setUserService($userService);

        return $this->serializer->serialize($request, 'xml');
    }

    /**
     * @return string
     */
    private function getRequestBody()
    {
        return '<SsoRequest>
            <Credentials>
                <ServiceProvider>
                    <ServiceToken><![CDATA[' . $this->serviceToken . ']]></ServiceToken>
                    <ServiceName><![CDATA[' . $this->serviceName . ']]></ServiceName>
                </ServiceProvider>
                <ServiceTrigger>
                    <UserIdentifier><![CDATA[' . $this->userIdentifier . ']]></UserIdentifier>
                    <Username><![CDATA[' . $this->username . ']]></Username>
                </ServiceTrigger>
                <ServiceCountry>
                    <Code><![CDATA[' . $this->langCode . ']]></Code>
                </ServiceCountry>
            </Credentials>
            <UserService>
                <PasswordRequest>
                    <Key>
                        <UserType>
                            <Identifier><![CDATA[' . $this->identifier . ']]></Identifier>
                        </UserType>
                    </Key>
                </PasswordRequest>
            </UserService>
        </SsoRequest>';
    }

    public function testGetterUserType()
    {
        /** @var  Request $requestModel */
        $requestModel = $this->serializer->deserialize(
            $this->setRequestBody(),
            Request::class,
            'xml'
        );

        $userService = $requestModel->getUserService()->getPasswordRequest();
        $userType = $userService->getKey()->getUserType();

        $credentials = $requestModel->getCredentials();

        $this->assertEquals($this->identifier, $userType->getIdentifier());
        $this->assertEquals($this->serviceToken, $credentials->getServiceProvider()->getServiceToken());
    }
}
