<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelXml\Request\UserWs\Version2\UserApplication\Show;

use Sso\RestBundle\ModelXml\Common\Request\Credentials\UserWs\Credentials;
use Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserApplication\Show\Factory;
use Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserApplication\Show;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

/**
 * Class FactoryTest
 * @package Sso\RestBundle\Tests\ModelXml\Request\UserWs\Version2\UserApplication\Show
 */
class FactoryTest extends WebTestCase
{
    /**
     * @var Factory
     */
    private $factory;

    public function setUp()
    {
        $this->factory = new Factory();
    }

    public function testRequestFactory()
    {
        static::assertInstanceOf(Show\Request::class, $this->factory->request());
    }

    public function testCredentialsFactory()
    {
        static::assertInstanceOf(Credentials::class, $this->factory->credentials());
    }

    public function testUserApplicationFactory()
    {
        static::assertInstanceOf(Show\UserApplication::class, $this->factory->userApplication());
    }
}
