<?php

/**
 * Class FactoryTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelXml\Request\UserWs\Version2\UserApplicationRole\Show;

use Sso\RestBundle\ModelXml\Common\Request\Credentials\UserWs\Credentials;
use Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserApplicationRole\Show;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

/**
 * Class FactoryTest
 * @package Sso\RestBundle\Tests\ModelXml\Request\UserWs\Version2\UserApplicationRole\Show
 */
class FactoryTest extends WebTestCase
{
    /**
     * @var Show\Factory
     */
    private $factory;

    /**
     * {@inheritDoc}
     */
    public function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->factory = new Show\Factory();
    }

    public function testRequestFactory()
    {
        static::assertInstanceOf(Show\Request::class, $this->factory->request());
    }

    public function testCredentialsFactory()
    {
        static::assertInstanceOf(Credentials::class, $this->factory->credentials());
    }

    public function testShowFactory()
    {
        static::assertInstanceOf(Show\Show::class, $this->factory->show());
    }

    public function testUserApplicationRoleFactory()
    {
        static::assertInstanceOf(Show\UserApplicationRole::class, $this->factory->userApplicationRole());
    }

    public function testKeyFactory()
    {
        static::assertInstanceOf(Show\Key::class, $this->factory->key());
    }
}