<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelXml\Request\UserWs\Version2\UserSearch\Advanced;

use Sso\RestBundle\ModelXml\Common\Request\Credentials\UserWs\Credentials;
use Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserSearch\Advanced\Factory;
use Sso\RestBundle\ModelXml\Request\UserWS\Version2\UserSearch\Advanced\Request;
use Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserSearch\Advanced\UserSearch;
use Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserSearch\Advanced\Advanced;
use PHPUnit\Framework\TestCase;

/**
 * Class FactoryTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class FactoryTest extends TestCase
{
    /**
     * @var Factory
     */
    private $factory;

    protected function setUp()
    {
        $this->factory = new Factory();
    }

    public function testRequest()
    {
        $this->assertInstanceOf(Request::class, $this->factory->request());
    }

    public function testCredentials()
    {
        $this->assertInstanceOf(Credentials::class, $this->factory->credentials());
    }

    public function testUserSearch()
    {
        $this->assertInstanceOf(UserSearch::class, $this->factory->userSearch());
    }

    public function testAdvanced()
    {
        $this->assertInstanceOf(Advanced::class, $this->factory->advanced());
    }
}
