<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelXml\Response\ObjectWs\Version1\Attribute;

use Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\Attribute\Factory;
use Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\Attribute\Add\Factory as AddFactory;
use Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\Attribute\Show\Factory as ShowFactory;
use Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\Attribute\Delete\Factory as DeleteFactory;
use Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\Attribute\Update\Factory as UpdateFactory;
use PHPUnit\Framework\TestCase;

/**
 * Class FactoryTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\RestBundle\Tests\ModelRest
 */
class FactoryTest extends TestCase
{
    /**
     * @var Factory
     */
    protected $factory;

    protected function setUp()
    {
        $this->factory = new Factory();
    }

//    public function testAddFactory()
//    {
//        $this->assertInstanceOf(AddFactory::class, $this->factory->add());
//    }

    public function testShowFactory()
    {
        $this->assertInstanceOf(ShowFactory::class, $this->factory->show());
    }

    public function testDeleteFactory()
    {
        $this->assertInstanceOf(DeleteFactory::class, $this->factory->delete());
    }

    public function testUpdateFactory()
    {
        $this->assertInstanceOf(UpdateFactory::class, $this->factory->update());
    }
}
