<?php

/**
 * Class ResponseTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelXml\Response\ObjectWs\Version1\AttributeGroup\Update\Success;

use Sso\RestBundle\Api\Manager as ApiManager;
use Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\AttributeGroup\Update\Success;
use Faker\Factory as FakerFactory;
use Faker\Generator as FakerGenerator;
use JMS\Serializer\SerializerInterface;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

/**
 * Class ResponseTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\Tests\ModelRest\Response\ObjectWs\Version1\AttributeGroup\Update
 */
class ResponseTest extends WebTestCase
{
    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @var ApiManager
     */
    private $apiManager;

    /**
     * @var FakerGenerator
     */
    private $faker;
    /**
     * @var Success\Response
     */
    private $response;

    protected function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->apiManager = new ApiManager(static::$kernel->getContainer());
        $this->serializer = $this->apiManager->serializer();
        $this->faker = FakerFactory::create();

        $this->setUpResponse();
    }

    private function setUpResponse()
    {
        $response = new Success\Response();
        $attributeGroup = new Success\AttributeGroup();
        $update = new Success\Update();
        $attributeGroupType = new Success\AttributeGroupType();

        $update
            ->setAttributeGroupType($attributeGroupType)
            ->setStatus($this->faker->text(10));

        $attributeGroupType
            ->setName($this->faker->name)
            ->setId($this->faker->uuid)
            ->addTypeId($this->faker->uuid)
            ->addTypeId($this->faker->uuid);

        $attributeGroup
            ->setUpdate($update);

        $response
            ->setTrackId($this->faker->uuid)
            ->setDate($this->faker->dateTime->format(\DateTime::ATOM))
            ->setStatus($this->faker->text(20))
            ->setAttributeGroup($attributeGroup);

        $this->response = $response;
    }

    public function testGetAndSetStatus()
    {
        $response = new Success\Response();

        $status = $this->faker->text(20);
        $response->setStatus($status);

        static::assertEquals($response->getStatus(), $status);
    }

    public function testGetAndSetTrackId()
    {
        $response = new Success\Response();

        $trackId = $this->faker->uuid;
        $response->setTrackId($trackId);

        static::assertEquals($response->getTrackId(), $trackId);
    }

    public function testGetAndSetDate()
    {
        $response = new Success\Response();

        $dateTime = $this->faker->dateTime;
        $response->setDate($dateTime->format(\DateTime::ATOM));

        static::assertEquals($response->getDate(), $dateTime);
    }

    public function testGetAndSetAttributeGroup()
    {
        $response = new Success\Response();
        $attributeGroup = new Success\AttributeGroup();

        $response->setAttributeGroup($attributeGroup);

        static::assertEquals($response->getAttributeGroup(), $attributeGroup);
    }

    public function testXMLSerialize()
    {
        static::assertXmlStringEqualsXmlString($this->serializer->serialize($this->response, 'xml'),
            $this->getExpectedResponseContent());
    }

    /**
     * @return string
     */
    private function getExpectedResponseContent()
    {
        return <<< XML
<?xml version="1.0" encoding="utf-8"?>
<SsoResponse>
    <Status><![CDATA[{$this->response->getStatus()}]]></Status>
    <Trackid><![CDATA[{$this->response->getTrackId()}]]></Trackid>
    <Date><![CDATA[{$this->response->getDate()->format(\DateTime::ATOM)}]]></Date>
    <AttributeGroup>
        <Update>
            <Status><![CDATA[{$this->response->getAttributeGroup()->getUpdate()->getStatus()}]]></Status>
            <AttributeGroupType>
                <Id>
                    <![CDATA[{$this->response->getAttributeGroup()->getUpdate()->getAttributeGroupType()->getId()}]]>
                </Id>
                <Name>
                    <![CDATA[{$this->response->getAttributeGroup()->getUpdate()->getAttributeGroupType()->getName()}]]>
                </Name>
                <Types>
                    <Id>
                        <![CDATA[{$this->response->getAttributeGroup()->getUpdate()->getAttributeGroupType()->getTypeIds()->get(0)}]]>
                    </Id>
                    <Id>
                        <![CDATA[{$this->response->getAttributeGroup()->getUpdate()->getAttributeGroupType()->getTypeIds()->get(1)}]]>
                    </Id>
                </Types>
            </AttributeGroupType>
        </Update>
    </AttributeGroup>
</SsoResponse>
XML;
    }
}