<?php

/**
 * Class FactoryTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelXml\Response\UserWs\Version1\User\Delete;

use Sso\RestBundle\ModelXml\Response\UserWs\Version1\User\Delete;
use PHPUnit\Framework\TestCase;

/**
 * Class FactoryTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class FactoryTest extends TestCase
{
    /**
     * @var Delete\Factory
     */
    protected $factory;

    protected function setUp()
    {
        $this->factory = new Delete\Factory();
    }

    public function testSuccessResponse()
    {
        static::assertInstanceOf(Delete\Success\Response::class, $this->factory->success());
    }

    public function testErrorResponse()
    {
        static::assertInstanceOf(Delete\Error\Response::class, $this->factory->error());
    }
}
