<?php

/**
 * Class FactoryTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelXml\Response\UserWs\Version1\UserApplication\Delete;

use Sso\RestBundle\ModelXml\Response\UserWs\Version1\UserApplication\Delete;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

/**
 * Class FactoryTest
 * @package Sso\RestBundle\Tests\ModelXml\Request\UserWs\Version1\UserApplication\Delete
 */
class FactoryTest extends WebTestCase
{
    /**
     * @var Delete\Factory
     */
    private $factory;

    /**
     * {@inheritDoc}
     */
    public function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->factory = new Delete\Factory();
    }

    public function testSuccessFactory()
    {
        static::assertInstanceOf(Delete\Success\Response::class, $this->factory->success());
    }

    public function testErrorFactory()
    {
        static::assertInstanceOf(Delete\Error\Response::class, $this->factory->error());
    }
}