<?php

/**
 * Class FactoryTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelXml\Response\UserWs\Version1\UserApplicationRole\Add;

use Sso\RestBundle\ModelXml\Response\UserWs\Version1\UserApplication\Add;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

/**
 * Class FactoryTest
 * @package Sso\RestBundle\Tests\ModelXml\Request\UserWs\Version1\UserApplicationRole\Add
 */
class FactoryTest extends WebTestCase
{
    /**
     * @var Add\Factory
     */
    private $factory;

    /**
     * {@inheritDoc}
     */
    public function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->factory = new Add\Factory();
    }

    public function testSuccessFactory()
    {
        static::assertInstanceOf(Add\Success\Response::class, $this->factory->success());
    }

    public function testErrorFactory()
    {
        static::assertInstanceOf(Add\Error\Response::class, $this->factory->error());
    }
}