<?php

/**
 * Class ResponseTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelXml\Response\UserWs\Version1\UserApplicationRole\Add\Success;

use Sso\RestBundle\Api\Manager as ApiManager;
use Sso\RestBundle\ModelXml\Response\UserWs\Version1\UserApplicationRole\Add\Success;
use Faker\Factory as FakerFactory;
use Faker\Generator as FakerGenerator;
use JMS\Serializer\SerializerInterface;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

/**
 * Class ResponseTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\Tests\ModelRest\Response\UserWs\Version1\UserApplicationRole\Add
 */
class ResponseTest extends WebTestCase
{
    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @var ApiManager
     */
    private $apiManager;

    /**
     * @var FakerGenerator
     */
    private $faker;
    /**
     * @var Success\Response
     */
    private $response;

    protected function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->apiManager = new ApiManager(static::$kernel->getContainer());
        $this->serializer = $this->apiManager->serializer();
        $this->faker = FakerFactory::create();

        $this->setUpResponse();
    }

    private function setUpResponse()
    {
        $response = new Success\Response();
        $userApplicationRole = new Success\UserApplicationRole();
        $add = new Success\Add();

        $add
            ->setStatus($this->faker->text(10))
            ->setMessage($this->faker->text(100));

        $userApplicationRole
            ->setAdd($add);

        $response
            ->setTrackId($this->faker->uuid)
            ->setDate($this->faker->dateTime)
            ->setStatus($this->faker->text(20))
            ->setUserApplicationRole($userApplicationRole);

        $this->response = $response;
    }

    public function testGetAndSetStatus()
    {
        $response = new Success\Response();

        $status = $this->faker->text(20);
        $response->setStatus($status);

        static::assertEquals($response->getStatus(), $status);
    }

    public function testGetAndSetTrackId()
    {
        $response = new Success\Response();

        $trackId = $this->faker->uuid;
        $response->setTrackId($trackId);

        static::assertEquals($response->getTrackId(), $trackId);
    }

    public function testGetAndSetDate()
    {
        $response = new Success\Response();

        $dateTime = $this->faker->dateTime;
        $response->setDate($dateTime);

        static::assertEquals($response->getDate(), $dateTime);
    }

    public function testGetAndSetUserApplicationRole()
    {
        $response = new Success\Response();
        $userApplicationRole = new Success\UserApplicationRole();

        $response->setUserApplicationRole($userApplicationRole);

        static::assertEquals($response->getUserApplicationRole(), $userApplicationRole);
    }

    public function testXMLSerialize()
    {
        static::assertXmlStringEqualsXmlString($this->serializer->serialize($this->response, 'xml'),
            $this->getExpectedResponseContent());
    }

    /**
     * @return string
     */
    private function getExpectedResponseContent()
    {
        return <<< XML
<?xml version="1.0" encoding="utf-8"?>
<SsoResponse>
  <Status>{$this->response->getStatus()}</Status>
  <Trackid>{$this->response->getTrackId()}</Trackid>
  <Date>{$this->response->getDate()->format(\DateTime::ATOM)}</Date>
  <UserApplicationRole>
    <Add>
      <Status>{$this->response->getUserApplicationRole()->getAdd()->getStatus()}</Status>
      <Message>{$this->response->getUserApplicationRole()->getAdd()->getMessage()}</Message>
    </Add>
  </UserApplicationRole>
</SsoResponse>
XML;
    }
}