<?php

/**
 * Class ResponseTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelXml\Response\UserWs\Version1\UserApplicationRole\Delete\Error;

use Sso\RestBundle\Api\Manager as ApiManager;
use Sso\RestBundle\ModelXml\Response\UserWs\Version1\UserApplicationRole\Delete\Error;
use Faker\Factory as FakerFactory;
use Faker\Generator as FakerGenerator;
use JMS\Serializer\SerializerInterface;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

/**
 * Class ResponseTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\Tests\ModelRest\Response\UserWs\Version1\UserApplicationRole\Delete
 */
class ResponseTest extends WebTestCase
{
    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @var ApiManager
     */
    private $apiManager;

    /**
     * @var FakerGenerator
     */
    private $faker;

    /**
     * @var int
     */
    private $code;

    /**
     * @var string
     */
    private $status;

    /**
     * @var string
     */
    private $trackId;

    /**
     * @var \DateTime
     */
    private $date;

    /**
     * @var \stdClass
     */
    private $error;

    protected function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->apiManager = new ApiManager(static::$kernel->getContainer());
        $this->serializer = $this->apiManager->serializer();
        $this->faker = FakerFactory::create();

        // Set same random data
        $this->status = $this->faker->name;
        $this->trackId = $this->faker->uuid;
        $this->date = $this->faker->dateTime;

        $this->error = new \stdClass();
        $this->error->code = $this->faker->randomNumber();
        $this->error->ref = $this->faker->sha1;
        $this->error->shortMessage = $this->faker->text(50);
        $this->error->longMessage = $this->faker->text(100);
    }

    public function testGetAndSetCode()
    {
        $response = new Error\Response();

        $response->setCode($this->code);

        static::assertEquals($response->getCode(), $this->code);
    }

    public function testGetAndSetStatus()
    {
        $response = new Error\Response();

        $response->setStatus($this->status);

        static::assertEquals($response->getStatus(), $this->status);
    }

    public function testGetAndSetTrackId()
    {
        $response = new Error\Response();

        $response->setTrackId($this->trackId);

        static::assertEquals($response->getTrackId(), $this->trackId);
    }

    public function testGetAndSetDate()
    {
        $response = new Error\Response();

        $response->setDate($this->date->format(\DateTime::ATOM));

        static::assertEquals($response->getDate(), $this->date);
    }

    public function testGetAndSetUserApplicationRole()
    {
        $response = new Error\Response();
        $userApplicationRole = new Error\UserApplicationRole();

        $response->setUserApplicationRole($userApplicationRole);

        static::assertEquals($response->getUserApplicationRole(), $userApplicationRole);
    }

    public function testXMLSerialize()
    {
        $response = new Error\Response();
        $userApplicationRole = new Error\UserApplicationRole();
        $delete = new Error\Delete();
        $error = new Error\Error();

        $error
            ->setErrorCode($this->error->code)
            ->setErrorRef($this->error->ref)
            ->setLongMessage($this->error->longMessage)
            ->setShortMessage($this->error->shortMessage);

        $delete
            ->setStatus($this->status)
            ->setError($error);

        $userApplicationRole
            ->setDelete($delete);

        $response
            ->setCode($this->code)
            ->setTrackId($this->trackId)
            ->setDate($this->date->format(\DateTime::ATOM))
            ->setStatus($this->status)
            ->setUserApplicationRole($userApplicationRole);

        static::assertXmlStringEqualsXmlString($this->serializer->serialize($response, 'xml'),
            $this->getExpectedResponseContent());
    }

    /**
     * @return string
     */
    private function getExpectedResponseContent()
    {
        return <<< XML
<?xml version="1.0" encoding="UTF-8"?>
<SsoResponse>
  <Status><![CDATA[{$this->status}]]></Status>
  <Trackid><![CDATA[{$this->trackId}]]></Trackid>
  <Date><![CDATA[{$this->date->format(\DateTime::ATOM)}]]></Date>
  <UserApplicationRole>
    <Delete>
      <Status><![CDATA[{$this->status}]]></Status>
      <Errors>
        <Error>
          <ErrorCode><![CDATA[{$this->error->code}]]></ErrorCode>
          <ErrorRef><![CDATA[{$this->error->ref}]]></ErrorRef>
          <ShortMessage><![CDATA[{$this->error->shortMessage}]]></ShortMessage>
          <LongMessage><![CDATA[{$this->error->longMessage}]]></LongMessage>
        </Error>
      </Errors>
    </Delete>
  </UserApplicationRole>
</SsoResponse>
XML;
    }
}