<?php

/**
 * Class ResponseTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelXml\Response\UserWs\Version1\UserApplicationRole\Delete\Success;

use Sso\RestBundle\Api\Manager as ApiManager;
use Sso\RestBundle\ModelXml\Response\UserWs\Version1\UserApplicationRole\Delete\Success;
use Faker\Factory as FakerFactory;
use Faker\Generator as FakerGenerator;
use JMS\Serializer\SerializerInterface;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

/**
 * Class ResponseTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\Tests\ModelRest\Response\UserWs\Version1\UserApplicationRole\Delete
 */
class ResponseTest extends WebTestCase
{
    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @var ApiManager
     */
    private $apiManager;

    /**
     * @var FakerGenerator
     */
    private $faker;

    /**
     * @var int
     */
    private $code;

    /**
     * @var string
     */
    private $status;

    /**
     * @var string
     */
    private $trackId;

    /**
     * @var string
     */
    private $message;

    /**
     * @var \DateTime
     */
    private $date;

    protected function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->apiManager = new ApiManager(static::$kernel->getContainer());
        $this->serializer = $this->apiManager->serializer();
        $this->faker = FakerFactory::create();

        // Set same random data
        $this->status = $this->faker->name;
        $this->trackId = $this->faker->uuid;
        $this->date = $this->faker->dateTime;
        $this->message = $this->faker->text(100);
    }

    public function testGetAndSetStatus()
    {
        $response = new Success\Response();

        $response->setStatus($this->status);

        static::assertEquals($response->getStatus(), $this->status);
    }

    public function testGetAndSetTrackId()
    {
        $response = new Success\Response();

        $response->setTrackId($this->trackId);

        static::assertEquals($response->getTrackId(), $this->trackId);
    }

    public function testGetAndSetDate()
    {
        $response = new Success\Response();

        $response->setDate($this->date->format(\DateTime::ATOM));

        static::assertEquals($response->getDate(), $this->date);
    }

    public function testGetAndSetUserApplication()
    {
        $response = new Success\Response();
        $userApplicationRole = new Success\UserApplicationRole();

        $response->setUserApplicationRole($userApplicationRole);

        static::assertEquals($response->getUserApplicationRole(), $userApplicationRole);
    }

    public function testXMLSerialize()
    {
        $response = new Success\Response();
        $userApplicationRole = new Success\UserApplicationRole();
        $delete = new Success\Delete();


        $delete
            ->setStatus($this->status)
            ->setMessage($this->message);

        $userApplicationRole
            ->setDelete($delete);

        $response
            ->setTrackId($this->trackId)
            ->setDate($this->date->format(\DateTime::ATOM))
            ->setStatus($this->status)
            ->setUserApplicationRole($userApplicationRole);

        static::assertXmlStringEqualsXmlString($this->serializer->serialize($response, 'xml'),
            $this->getExpectedResponseContent());
    }

    /**
     * @return string
     */
    private function getExpectedResponseContent()
    {
        return <<< XML
<?xml version="1.0" encoding="utf-8"?>
<SsoResponse>
  <Status>{$this->status}</Status>
  <Trackid>{$this->trackId}</Trackid>
  <Date>{$this->date->format(\DateTime::ATOM)}</Date>
  <UserApplicationRole>
    <Delete>
      <Status>{$this->status}</Status>
      <Message>{$this->message}</Message>
    </Delete>
  </UserApplicationRole>
</SsoResponse>
XML;
    }
}