<?php

/**
 * Class ResponseTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelXml\Response\UserWs\Version1\UserService\ActivateConfirm\Success;

use Sso\RestBundle\Api\Manager as ApiManager;
use Sso\RestBundle\ModelXml\Response\UserWs\Version1\UserService\ActivateConfirm\Success;
use Faker\Factory as FakerFactory;
use Faker\Generator as FakerGenerator;
use JMS\Serializer\SerializerInterface;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

/**
 * Class ResponseTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\Tests\ModelRest\Response\UserWs\Version1\UserService\ActivateConfirm
 */
class ResponseTest extends WebTestCase
{
    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @var ApiManager
     */
    private $apiManager;

    /**
     * @var FakerGenerator
     */
    private $faker;
    /**
     * @var Success\Response
     */
    private $response;

    protected function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->apiManager = new ApiManager(static::$kernel->getContainer());
        $this->serializer = $this->apiManager->serializer();
        $this->faker = FakerFactory::create();

        $this->setUpResponse();
    }

    private function setUpResponse()
    {
        $response = new Success\Response();
        $userService = new Success\UserService();
        $activateConfirm = new Success\ActivateConfirm();

        $activateConfirm
            ->setStatus($this->faker->text(10))
            ->setMessage($this->faker->text);

        $userService
            ->setActivateConfirm($activateConfirm);

        $response
            ->setTrackId($this->faker->uuid)
            ->setDate($this->faker->dateTime)
            ->setStatus($this->faker->text(20))
            ->setUserService($userService);

        $this->response = $response;
    }

    public function testGetAndSetStatus()
    {
        $response = new Success\Response();

        $status = $this->faker->text(20);
        $response->setStatus($status);

        static::assertEquals($response->getStatus(), $status);
    }

    public function testGetAndSetTrackId()
    {
        $response = new Success\Response();

        $trackId = $this->faker->uuid;
        $response->setTrackId($trackId);

        static::assertEquals($response->getTrackId(), $trackId);
    }

    public function testGetAndSetDate()
    {
        $response = new Success\Response();

        $dateTime = $this->faker->dateTime;
        $response->setDate($dateTime);

        static::assertEquals($response->getDate(), $dateTime);
    }

    public function testGetAndSetUserService()
    {
        $response = new Success\Response();
        $userService = new Success\UserService();

        $response->setUserService($userService);

        static::assertEquals($response->getUserService(), $userService);
    }

    public function testXMLSerialize()
    {
        static::assertXmlStringEqualsXmlString($this->serializer->serialize($this->response, 'xml'),
            $this->getExpectedResponseContent());
    }

    /**
     * @return string
     */
    private function getExpectedResponseContent()
    {
        return <<< XML
<?xml version="1.0" encoding="utf-8"?>
<SsoResponse>
  <Status>{$this->response->getStatus()}</Status>
  <Trackid>{$this->response->getTrackId()}</Trackid>
  <Date>{$this->response->getDate()->format(\DateTime::ATOM)}</Date>
  <UserService>
    <ActivateConfirm>
      <Status>{$this->response->getUserService()->getActivateConfirm()->getStatus()}</Status>
      <Message>{$this->response->getUserService()->getActivateConfirm()->getMessage()}</Message>
    </ActivateConfirm>
  </UserService>
</SsoResponse>
XML;
    }
}