<?php

/**
 * Class ResponseTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelXml\Response\UserWs\Version1\UserService\ActivateRequest\Error;

use Sso\RestBundle\Api\Manager as ApiManager;
use Sso\RestBundle\ModelXml\Response\UserWs\Version1\UserService\ActivateRequest\Error;
use Faker\Factory as FakerFactory;
use Faker\Generator as FakerGenerator;
use JMS\Serializer\SerializerInterface;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

/**
 * Class ResponseTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\Tests\ModelRest\Response\UserWs\Version1\UserService\ActivateRequest
 */
class ResponseTest extends WebTestCase
{
    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @var ApiManager
     */
    private $apiManager;

    /**
     * @var FakerGenerator
     */
    private $faker;

    /**
     * @var Error\Response
     */
    private $response;

    protected function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->apiManager = new ApiManager(static::$kernel->getContainer());
        $this->serializer = $this->apiManager->serializer();
        $this->faker = FakerFactory::create();

        $this->setUpResponse();
    }

    private function setUpResponse()
    {
        $response = new Error\Response();
        $userService = new Error\UserService();
        $activateRequest = new Error\ActivateRequest();
        $error = new Error\Error();

        $error
            ->setErrorCode($this->faker->randomNumber())
            ->setErrorRef($this->faker->sha1)
            ->setLongMessage($this->faker->text(100))
            ->setShortMessage($this->faker->text(50));

        $activateRequest
            ->setStatus($this->faker->text(10))
            ->addError($error);

        $userService
            ->setActivateRequest($activateRequest);

        $response
            ->setTrackId($this->faker->uuid)
            ->setDate($this->faker->dateTime)
            ->setStatus($this->faker->text(20))
            ->setUserService($userService);

        $this->response = $response;
    }

    public function testGetAndSetStatus()
    {
        $response = new Error\Response();

        $status = $this->faker->text(20);
        $response->setStatus($status);

        static::assertEquals($response->getStatus(), $status);
    }

    public function testGetAndSetTrackId()
    {
        $response = new Error\Response();

        $trackId = $this->faker->uuid;
        $response->setTrackId($trackId);

        static::assertEquals($response->getTrackId(), $trackId);
    }

    public function testGetAndSetDate()
    {
        $response = new Error\Response();

        $dateTime = $this->faker->dateTime;
        $response->setDate($dateTime);

        static::assertEquals($response->getDate(), $dateTime);
    }

    public function testGetAndSetUserServiceRole()
    {
        $response = new Error\Response();
        $userService = new Error\UserService();

        $response->setUserService($userService);

        static::assertEquals($response->getUserService(), $userService);
    }

    public function testXMLSerialize()
    {
        static::assertXmlStringEqualsXmlString($this->serializer->serialize($this->response, 'xml'),
            $this->getExpectedResponseContent());
    }

    /**
     * @return string
     */
    private function getExpectedResponseContent()
    {
        return <<< XML
<?xml version="1.0" encoding="utf-8"?>
<SsoResponse>
  <Status><![CDATA[{$this->response->getStatus()}]]></Status>
  <Trackid>{$this->response->getTrackId()}</Trackid>
  <Date>{$this->response->getDate()->format(\DateTime::ATOM)}</Date>
  <UserService>
    <ActivateRequest>
      <Status><![CDATA[{$this->response->getUserService()->getActivateRequest()->getStatus()}]]></Status>
      <Errors>
        <Error>
          <ErrorCode><![CDATA[{$this->response->getUserService()->getActivateRequest()->getErrors()->get(0)->getErrorCode()}]]></ErrorCode>
          <ErrorRef><![CDATA[{$this->response->getUserService()->getActivateRequest()->getErrors()->get(0)->getErrorRef()}]]></ErrorRef>
          <ShortMessage><![CDATA[{$this->response->getUserService()->getActivateRequest()->getErrors()->get(0)->getShortMessage()}]]></ShortMessage>
          <LongMessage><![CDATA[{$this->response->getUserService()->getActivateRequest()->getErrors()->get(0)->getLongMessage()}]]></LongMessage>
        </Error>
      </Errors>
    </ActivateRequest>
  </UserService>
</SsoResponse>
XML;
    }
}