<?php

/**
 * Class FactoryTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelXml\Response\UserWs\Version1\UserService;

use Sso\RestBundle\ModelXml\Response\UserWs\Version1\UserService;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

/**
 * Class FactoryTest
 * @package Sso\RestBundle\Tests\ModelXml\Response\UserWs\Version1\UserService
 */
class FactoryTest extends WebTestCase
{
    /**
     * @var UserService\Factory
     */
    private $factory;

    /**
     * {@inheritDoc}
     */
    public function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->factory = new UserService\Factory();
    }

    public function testActivateRequest()
    {
        static::assertInstanceOf(UserService\ActivateRequest\Factory::class, $this->factory->activateRequest());
    }

    public function testActivateConfirm()
    {
        static::assertInstanceOf(UserService\ActivateConfirm\Factory::class, $this->factory->activateConfirm());
    }

    public function testPasswordRequestFactory()
    {
        static::assertInstanceOf(UserService\PasswordRequest\Factory::class, $this->factory->passwordRequest());
    }

    public function testPasswordConfirmFactory()
    {
        static::assertInstanceOf(UserService\PasswordConfirm\Factory::class, $this->factory->passwordConfirm());
    }
}
