<?php

/**
 * Class ResponseTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelXml\Response\UserWs\Version2\UserApplicationRole\Show\Error;

use Sso\RestBundle\Api\Manager as ApiManager;
use Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserApplicationRole\Show\Error;
use JMS\Serializer\SerializerInterface;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

/**
 * Class ResponseTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\Tests\ModelRest\Response\UserWs\Version2\UserApplicationRole\Show\Error
 */
class ResponseTest extends WebTestCase
{
    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @var ApiManager
     */
    private $apiManager;

    /**
     * @var Error\Response
     */
    private $response;

    protected function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->apiManager = new ApiManager(static::$kernel->getContainer());
        $this->serializer = $this->apiManager->serializer();

        $this->setUpResponse();
    }

    private function setUpResponse()
    {
        $response = new Error\Response();
        $error = new Error\Error();

        $error->setCode(404)
            ->setStatus('Not Found')
            ->setErrorCode('u001')
            ->setErrorRef('u2016')
            ->setShortMessage('Invalid user')
            ->setLongMessage('User not found in database')
            ->setType('External Error');

        $response->setCode(404)
            ->setStatus('Not Found')
            ->setTrackId('05d8386940')
            ->setController('UserApplicationRole')
            ->setAction('Show')
            ->setDate(new \DateTime())
            ->setScriptTimeSec(0.413)
            ->setErrorCount(1)
            ->setErrors($error);

        $this->response = $response;
    }

    public function testGetAndSetCode()
    {
        $response = new Error\Response();
        $response->setCode(400);

        static::assertEquals($response->getCode(), 400);
    }

    public function testGetAndSetStatus()
    {
        $response = new Error\Response();
        $response->setStatus('Not Found');

        static::assertEquals($response->getStatus(), 'Not Found');
    }

    public function testGetAndSetTrackId()
    {
        $response = new Error\Response();
        $response->setTrackId('05d8386940');

        static::assertEquals($response->getTrackId(), '05d8386940');
    }

    public function testGetAndSetController()
    {
        $response = new Error\Response();
        $response->setController('UserApplicationRole');

        static::assertEquals($response->getController(), 'UserApplicationRole');
    }

    public function testGetAndSetAction()
    {
        $response = new Error\Response();
        $response->setAction('Show');

        static::assertEquals($response->getAction(), 'Show');
    }

    public function testGetAndSetDate()
    {
        $response = new Error\Response();
        $dateTime = new \DateTime();
        $response->setDate($dateTime);

        static::assertEquals($response->getDate(), $dateTime);
    }

    public function testGetAndSetScriptTimeSec()
    {
        $response = new Error\Response();
        $response->setScriptTimeSec(0.413);

        static::assertEquals($response->getScriptTimeSec(), 0.413);
    }

    public function testGetAndSetErrorCount()
    {
        $response = new Error\Response();
        $response->setErrorCount(1);

        static::assertEquals($response->getErrorCount(), 1);
    }

    public function testXMLSerialize()
    {
        static::assertXmlStringEqualsXmlString($this->serializer->serialize($this->response, 'xml'),
            $this->getExpectedResponseContent());
    }

    /**
     * @return string
     */
    private function getExpectedResponseContent()
    {
        return <<< XML
<?xml version="1.0" encoding="UTF-8"?>
<SsoResponse>
    <Code><![CDATA[{$this->response->getCode()}]]></Code>
    <Status>
        <![CDATA[{$this->response->getStatus()}]]>
    </Status>
    <TrackId>
        <![CDATA[{$this->response->getTrackId()}]]>
    </TrackId>
    <Controller>
        <![CDATA[{$this->response->getController()}]]>
    </Controller>
    <Action>
        <![CDATA[{$this->response->getAction()}]]>
    </Action>
    <Date>
        <![CDATA[{$this->response->getDate()->format(\DateTime::ATOM)}]]>
    </Date>
    <ScriptTimeSec>{$this->response->getScriptTimeSec()}</ScriptTimeSec>
    <ErrorCount>{$this->response->getErrorCount()}</ErrorCount>
    <Errors>
        <Error>
            <Code>{$this->response->getErrors()->get(0)->getCode()}</Code>
            <Status>
                <![CDATA[{$this->response->getErrors()->get(0)->getStatus()}]]>
            </Status>
            <ErrorCode>
                <![CDATA[{$this->response->getErrors()->get(0)->getErrorCode()}]]>
            </ErrorCode>
            <ErrorReference>
                <![CDATA[{$this->response->getErrors()->get(0)->getErrorRef()}]]>
            </ErrorReference>
            <ShortMessage>
                <![CDATA[{$this->response->getErrors()->get(0)->getShortMessage()}]]>
            </ShortMessage>
            <LongMessage>
                <![CDATA[{$this->response->getErrors()->get(0)->getLongMessage()}]]>
            </LongMessage>
            <Type>
                <![CDATA[{$this->response->getErrors()->get(0)->getType()}]]>
            </Type>
        </Error>
    </Errors>
</SsoResponse>
XML;
    }
}
