<?php
/**
 * Class FactoryTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\Worker\UserWs\Version2;

use Sso\RestBundle\Api;
use Sso\RestBundle\Worker\UserWs\Version2;
use GuzzleHttp\Client;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;
use Symfony\Component\DependencyInjection\ContainerInterface;

class FactoryTest extends WebTestCase
{
    /**
     * @var Api\Manager
     */
    public $apiM;

    /**
     *
     * @var Client
     */
    protected $client;

    /**
     *
     * @var ContainerInterface
     */
    protected $container;

    protected function setUp()
    {
        $this->client = static::createClient();
        $this->container = $this->client->getContainer();
        $this->apiM = new Api\Manager($this->container);
    }

    public function testUserApplicationFactory()
    {
        static::assertInstanceOf(
            Version2\UserApplication\Factory::class,
            $this->apiM->worker()->userWs()->version2()->userApplication()
        );
    }

    public function testUserApplicationRoleFactory()
    {
        static::assertInstanceOf(
            Version2\UserApplicationRole\Factory::class,
            $this->apiM->worker()->userWs()->version2()->userApplicationRole()
        );
    }
}