<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Worker\IdpWs\ServiceUser;

use Sso\RestBundle\Api;

/**
 * Class Factory
 * @package Sso\RestBundle\Worker\IdpWs\ServiceUser
 */
class Factory
{
    /**
     * @var array
     */
    protected $facSetter;

    /**
     *
     * @var Api\Manager
     */
    protected $apiM;

    /**
     * @param Api\Manager $apiM
     */
    public function __construct(Api\Manager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     *
     * @return GetUserIdentifier\Handler
     */
    public function getUserIdentifier()
    {
        if (!isset($this->facSetter['getUserIdentifier'])) {
            $this->facSetter['getUserIdentifier'] = new GetUserIdentifier\Handler($this->apiM);
        }

        return $this->facSetter['getUserIdentifier'];
    }

    /**
     * @return GetValidateUserIdentifier\Handler
     */
    public function getValidateUserIdentifier()
    {
        if (!isset($this->facSetter['getValidateUserIdentifier'])) {
            $this->facSetter['getValidateUserIdentifier'] = new GetValidateUserIdentifier\Handler($this->apiM);
        }

        return $this->facSetter['getValidateUserIdentifier'];
    }
}
