<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Worker\MultipleWs\Version1\UserACL\Validate;

use Doctrine\ORM\Query\Parameter;
use FOS\RestBundle\View\View as RestView;
use Sso\RestBundle\Api\Manager as ApiManager;
use LifeStyle\Tools\RestErrorBundle\Api\Manager as ErrorApi;
use LifeStyle\Tools\RestErrorBundle\Api\Error\Errors\Index as Errors;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use FOS\RestBundle\Request\ParamFetcher;
use Sso\RestBundle\Worker\UserWs\Version2\UserApplication\ShowDetails as ShowDetails;
use Sso\RestBundle\Worker\IdpWs\ServiceUser\GetValidateUserIdentifier as ValidateIdentifier;

/**
 * Class Handler
 * @package Sso\RestBundle\Worker\MultipleWs\Version1\UserACL\Validate
 */
class Handler
{
    /**
     * @var ApiManager
     */
    protected $apiM;

    /**
     * @var ErrorApi
     */
    protected $errorApi;

    /**
     * @var Errors
     */
    protected $errors;

    /**
     * @var string
     */
    protected $format = "json";

    /**
     * @var
     */
    protected $validateIdentifier;

    /**
     * @var
     */
    protected $userApplicationDetails;


    /**
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
        $this->errorApi = $this->apiM->errorManager();
        $this->errors = $this->errorApi->error()->errors();
        $this->format = 'json';

        $this->userApplicationDetails = new ShowDetails\Handler($this->apiM);
        $this->validateIdentifier = new ValidateIdentifier\Handler($this->apiM);
    }


    /**
     * @param Request $request
     * @return RestView|null
     */
    public function init(Request $request)
    {
        /**
         * @var \Sso\RestBundle\ModelRest\Response\IdpWs\ServiceUser\Get\UserIdentifier $userApplicationValidateIdentifierResult
         */
        $userApplicationValidateIdentifierResult = $this->validateIdentifier->init($request)->getData();
        // attension should be 200 must fix in service!!!!!
        if (200 !== $userApplicationValidateIdentifierResult->getCode()) {
            return $userApplicationValidateIdentifierResult;
        }
        /**
         * @var \Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserApplication\ShowDetails\Success\Response $userApplicationShowDetailsResult
         */
        $userApplicationShowDetailsResult = $this->userApplicationDetails->init($request)->getData();

        $responseView = $this->buildResponseView($userApplicationValidateIdentifierResult,
            $userApplicationShowDetailsResult);

        // fill the real response model
        $view = RestView::create();
        $view->setData($responseView);
        return $view;
    }

    /**
     * @param \Sso\RestBundle\ModelRest\Response\IdpWs\ServiceUser\Get\UserIdentifier $userApplicationValidateIdentifierResult
     * @param  $userApplicationShowDetailsResult
     * @return \Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserApplication\ShowDetails\Error\Response|\Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserApplication\ShowDetails\Success\Response
     */
    private function buildResponseView(
        \Sso\RestBundle\ModelRest\Response\IdpWs\ServiceUser\Get\UserIdentifier $userApplicationValidateIdentifierResult,
        $userApplicationShowDetailsResult
    ) {

        if ($userApplicationShowDetailsResult->getCode() != 200) {
            $responseView = $this->apiM->modelRest()->response()->userWs()->version2()->userApplication()->showDetails()->error()->response();
            $responseView->setError($userApplicationShowDetailsResult->getError());
            return $responseView;
        }

        $responseView = $this->apiM->modelRest()->response()->userWs()->version2()->userApplication()->showDetails()->success()->response();
        $responseView->setUserApplication($userApplicationShowDetailsResult->getUserApplication());

        return $responseView;

    }
}
