<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Worker\ObjectWs\Version1\Object\Show;

use Sso\RestBundle\Api;
use GuzzleHttp\Client;

/**
 * Class Factory
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\RestBundle\Worker\ObjectWs\Version1\Object\Show
 */
class Factory
{
    /**
     * @var array
     */
    protected $facSetter;

    /**
     * @var Api\Manager
     */
    protected $apiM;

    /**
     * @param Api\Manager $apiM
     */
    public function __construct(Api\Manager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @return Single\Handler
     */
    public function single()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Single\Handler($this->apiM);
        }

        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return Multi\Handler
     */
    public function multi()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Multi\Handler($this->apiM);
        }

        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return Tree\Handler
     */
    public function tree()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Tree\Handler($this->apiM);
        }

        return $this->facSetter[__FUNCTION__];
    }

}
