<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Worker\UserWs\Version1\UserService;

use Sso\RestBundle\Api;

/**
 * Class Factory
 * @package Sso\RestBundle\Worker\UserWs\Version1\UserService
 */
class Factory
{
    /**
     * @var array
     */
    protected $facSetter;

    /**
     * @var Api\Manager
     */
    protected $apiM;

    /**
     * @param Api\Manager $apiM
     */
    public function __construct(Api\Manager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @return ActivateRequest\Handler
     */
    public function activateRequest()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new ActivateRequest\Handler($this->apiM);
        }

        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return ActivateConfirm\Handler
     */
    public function activateConfirm()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new ActivateConfirm\Handler($this->apiM);
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return PasswordRequest\Handler
     */
    public function passwordRequest()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new PasswordRequest\Handler($this->apiM);
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return PasswordConfirm\Handler
     */
    public function passwordConfirm()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new PasswordConfirm\Handler($this->apiM);
        }
        return $this->facSetter[__FUNCTION__];
    }
}
