<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Worker\UserWs\Version2\UserSearch;

use Sso\RestBundle\Api;

/**
 * Class Factory
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\Worker\UserWs\Version2\UserSearch
 */
class Factory
{
    /**
     * @var array
     */
    protected $facSetter;

    /**
     * @var Api\Manager
     */
    protected $apiM;

    /**
     * @param Api\Manager $apiM
     */
    public function __construct(Api\Manager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @return Advanced\Handler
     */
    public function advanced()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Advanced\Handler($this->apiM);
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return FindByApplication\Handler
     */
    public function findByApplication()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new FindByApplication\Handler($this->apiM);
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return FindByApplicationAttribute\Handler
     */
    public function findByApplicationAttribute()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new FindByApplicationAttribute\Handler($this->apiM);
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return FindByApplicationRole\Handler
     */
    public function findByApplicationRole()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new FindByApplicationRole\Handler($this->apiM);
        }
        return $this->facSetter[__FUNCTION__];
    }
}
