<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Worker;

use Sso\RestBundle\Api;

/**
 * Class Worker
 * @package Sso\RestBundle\Worker
 */
class Worker
{
    /**
     * @var array
     */
    protected $woSetter;

    /**
     * @var Api\Manager
     */
    protected $apiM;

    /**
     * @param Api\Manager $apiM
     */
    public function __construct(Api\Manager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @return IdpWs\Factory
     *
     */
    public function idpWs()
    {
        if (!isset($this->woSetter[__FUNCTION__])) {
            $this->woSetter[__FUNCTION__] = new IdpWs\Factory($this->apiM);
        }
        return $this->woSetter[__FUNCTION__];
    }

    /**
     * @return MultipleWs\Factory
     */
    public function multipleWs()
    {
        if (!isset($this->woSetter[__FUNCTION__])) {
            $this->woSetter[__FUNCTION__] = new MultipleWs\Factory($this->apiM);
        }
        return $this->woSetter[__FUNCTION__];
    }

    /**
     * @return ObjectWs\Factory
     */
    public function objectWs()
    {
        if (!isset($this->woSetter[__FUNCTION__])) {
            $this->woSetter[__FUNCTION__] = new ObjectWs\Factory($this->apiM);
        }
        return $this->woSetter[__FUNCTION__];
    }

    /**
     * @return UserWs\Factory
     */
    public function userWs()
    {
        if (!isset($this->woSetter[__FUNCTION__])) {
            $this->woSetter[__FUNCTION__] = new UserWs\Factory($this->apiM);
        }
        return $this->woSetter[__FUNCTION__];
    }
}
