<?php

/**
 * Twig extension to make AWS Instance-Id visible in templates
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Tools\AWSBundle\Twig\Extension;

use Guzzle\Service\Client;

class AWS extends \Twig_Extension
{

    /**
     * Guzzle client
     *
     * @var \Guzzle\Service\Client
     */
    private $client;

    /**
     * AWS-Instance-Id
     *
     * @var string
     */
    private $awsInstanceId;

    /**
     * Constructor
     *
     * @param \Guzzle\Service\Client $client
     */
    public function __construct(Client $client)
    {
        $this->client = $client;
    }

    /**
     * Get extension-name
     *
     * @return string
     */
    public function getName()
    {
        return 'sso-aws-extension';
    }

    /**
     * Get global variables
     *
     * @return array
     */
    public function getGlobals()
    {
        return array(
            'awsInstanceId' => $this->awsInstanceId(),
        );
    }

    /**
     * Get aws instance id
     *
     * @return string
     */
    private function awsInstanceId()
    {
        if (false === getenv('APP_LOGS')) {
            return '';
        }
        return null !== $this->awsInstanceId ? $this->awsInstanceId : ($this->awsInstanceId = (string)$this->client->createRequest()->send()->getBody(true));
    }

}