<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Tools\UserIdentifierBundle\Model;

use JMS\Serializer\Annotation as Serializer;

/**
 * @Serializer\XmlRoot("SsoRequest")
 */
class Request
{
    /**
     * @var Request\Node\Factory
     */
    private $nodeFactory;

    /**
     * @Serializer\SerializedName("Credentials")
     * @Serializer\Type("Sso\Tools\UserIdentifierBundle\Model\Request\Node\Credentials")
     * @var Credentials
     */
    private $credentials;

    /**
     * @Serializer\SerializedName("UserIdentifier")
     * @Serializer\Type("Sso\Tools\UserIdentifierBundle\Model\Request\UserIdentifier")
     * @var Request\UserIdentifier
     */
    private $userIdentifierController;

    /**
     *
     * @param Request\Node\Factory $nodeFactory
     */
    public function __construct(Request\Node\Factory $nodeFactory)
    {
        $this->nodeFactory = $nodeFactory;
    }

    /**
     *
     * @return Request\Node\Credentials
     */
    public function credentials()
    {
        return null !== $this->credentials ? $this->credentials : ($this->credentials = $this->nodeFactory->credentials());
    }

    /**
     * @return Request\UserIdentifier
     */
    public function userIdentifier()
    {
        return null !== $this->userIdentifierController ? $this->userIdentifierController : ($this->userIdentifierController = $this->nodeFactory->userIdentifier());
    }

}