<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Tools\UserIdentifierBundle\Model\Request\Node;

use JMS\Serializer\Annotation as Serializer;
use Sso\Tools\UserIdentifierBundle\Model\Request\Node\UserType;

/**
 * Class Key
 * @package Sso\Tools\UserIdentifierBundle\Model\Request\Node
 */
class Key
{
    /**
     * @var Factory
     */
    private $nodeFactory;

    /**
     * @Serializer\SerializedName("UserType")
     * @Serializer\Type("Sso\Tools\UserIdentifierBundle\Model\Request\Node\UserType")
     * @var UserType
     */
    private $userType;

    /**
     *
     * @param Factory $nodeFactory
     */
    public function __construct(Factory $nodeFactory)
    {
        $this->nodeFactory = $nodeFactory;
    }

    /**
     * @return UserType
     */
    public function userType()
    {
        return null !== $this->userType ? $this->userType : ($this->userType = $this->nodeFactory->userType());
    }
}
