<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace ProcessLock\Model;

use ProcessLock\Exception\AlreadyLockedException;
use ProcessLock\Exception\UnlockException;

/**
 * Class LockerInterface
 * @package ProcessLock\Model
 */
interface LockerInterface
{
    /**
     * @throws AlreadyLockedException
     */
    public function lock();

    /**
     * @return bool
     */
    public function isLocked();

    /**
     * @throws UnlockException
     */
    public function unlock();
}
