<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */


namespace Tests\ProcessLock;

use ProcessLock\Exception\AlreadyLockedException;
use ProcessLock\Locker;
use ProcessLock\Model\Config;
use ProcessLock\Model\LockerInterface;

class LockerTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @var LockerInterface
     */
    private $locker;

    protected function setUp()
    {
        $this->locker = new Locker(new Config('test-process', 2));
    }

    protected function tearDown()
    {
        $this->locker->unlock();
    }

    public function test_lock_unlock()
    {
        $this->locker->lock();
        self::assertTrue($this->locker->isLocked());

        $this->locker->unlock();
        self::assertFalse($this->locker->isLocked());
    }

    public function test_already_locked_failure()
    {
        self::expectException(AlreadyLockedException::class);

        $this->locker->lock();
        $this->locker->lock();
    }

    public function test_is_expired_by_time_to_live()
    {
        $this->locker->lock();
        sleep(3);
        $this->locker->lock();  // there must not be thrown an AlreadyLockedException!
        $this->locker->unlock();

        self::assertFalse($this->locker->isLocked());
    }

    public function test_already_unlocked()
    {
        self::assertFalse($this->locker->isLocked());

        $this->locker->unlock();

        self::assertFalse($this->locker->isLocked());
    }
}
