<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Tests\ProcessLock\Model;


use ProcessLock\Model\Config;

class ConfigTest extends \PHPUnit_Framework_TestCase
{
    public function test_config()
    {
        $config = new Config('test-process', 400);

        self::assertSame('test-process', $config->getProcessName());
        self::assertSame(400, $config->getProcessTTL());
    }

    public function test_config__ttl_default()
    {
        $config = new Config('test-process');

        self::assertSame('test-process', $config->getProcessName());
        self::assertSame(900, $config->getProcessTTL());
    }
}
