<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace ProcessLock;

use ProcessLock\Exception\LockerBuildException;
use ProcessLock\Model\Config;

class LockerBuilder
{
    /**
     * @var string
     */
    private $processName;

    /**
     * @var int the time to live in seconds
     */
    private $processTTL = -1;

    /**
     * @return LockerBuilder
     */
    public static function create()
    {
        return new LockerBuilder();
    }

    /**
     * @param string $processName
     * @return LockerBuilder
     */
    public function withProcessName($processName)
    {
        $this->processName = $processName;
        return $this;
    }

    /**
     * @param int $timeToLive
     * @return LockerBuilder
     */
    public function withProcessTimeToLive($timeToLive)
    {
        $this->processTTL = $timeToLive;
        return $this;
    }

    /**
     * @return Locker
     */
    public function build()
    {
        if (!$this->processName || empty(trim($this->processName))) {
            throw new LockerBuildException('you must define a process name');
        }

        $config = new Config(
            $this->processName,
            $this->processTTL !== -1 ? $this->processTTL : Config::DEFAULT_TTL
        );

        return new Locker($config);
    }
}
