<?php

use ProcessLock\Exception\AlreadyLockedException;
use ProcessLock\LockerBuilder;

require (__DIR__ . '/vendor/autoload.php') ;

// Configuration of the process locker.
$processLock = LockerBuilder::create()
    ->withProcessName('test-process')
    ->withProcessTimeToLive(900)
    ->build();

// Lock the process
$processLock->lock();

// do your things here...

$processLock->unlock();


// If you want to lock the process again, but it is already locked, you can catch the exception
// in this example you can also find an example for checking the elapsed time.
try {
    $processLock->lock();
    $processLock->lock();
} catch (AlreadyLockedException $exception) {
    if ($processLock->getElapsedTime()) {
        // do something ... for example send an email
    }
}