<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace ProcessLock\Model;

/**
 * Class Config
 * @package ProcessLock\Model
 */
class Config
{
    const DEFAULT_TTL = 900;

    /**
     * The name of the process
     * @var string
     */
    private $processName;

    /**
     * The time to live in seconds. Default is 900, so 15 minutes.
     * @var int
     */
    private $processTTL;

    /**
     * Config constructor.
     * @param string $processName The name of the process
     * @param int $processTTL The time to live in seconds. Default is 900, so 15 minutes.
     */
    public function __construct($processName, $processTTL = self::DEFAULT_TTL)
    {
        $this->processName = $processName;
        $this->processTTL = $processTTL;
    }

    /**
     * @return string
     */
    public function getProcessName()
    {
        return $this->processName;
    }

    /**
     * @return int
     */
    public function getProcessTTL()
    {
        return $this->processTTL;
    }
}
