<?php

namespace Publikat\CacheBundle\Model;

use JMS\Serializer\Annotation as Serializer;

/**
 * @package Publikat\Api\Shop\Price\Model
 *
 * @Serializer\XmlRoot("StylefileProductResponse")
 */
class PriceResponse
{
    /**
     * @Serializer\SerializedName("productGroupId")
     * @Serializer\Type("string")
     *
     * @var string;
     */
    private $productGroupId;

    /**
     * @Serializer\SerializedName("articleNumberId")
     * @Serializer\Type("string")
     *
     * @var string;
     */
    private $articleNumberId;

    /**
     * @Serializer\SerializedName("currentPrice")
     * @Serializer\Type("double")
     *
     * @var float;
     */
    private $currentPrice;

    /**
     * @Serializer\SerializedName("originalPrice")
     * @Serializer\Type("double")
     *
     * @var float;
     */
    private $originalPrice;

    /**
     * @Serializer\SerializedName("currency")
     * @Serializer\Type("string")
     *
     * @var string;
     */
    private $currency;

    /**
     * @Serializer\SerializedName("isSpecialPrice")
     * @Serializer\Type("boolean")
     *
     * @var bool;
     */
    private $isSpecialPrice;

    /**
     * @Serializer\SerializedName("amount")
     * @Serializer\Type("integer")
     *
     * @var int;
     */
    private $amount;

    /**
     * @Serializer\SerializedName("status")
     * @Serializer\Type("string")
     *
     * @var string;
     */
    private $status;

    /**
     * @Serializer\SerializedName("statusMessage")
     * @Serializer\Type("array<string>")
     *
     * @var [];
     */
    private $statusMessages;

    /**
     * @Serializer\SerializedName("currentPriceNet")
     * @Serializer\Type("double")
     *
     * @var float;
     */
    private $currentPriceNet;

    /**
     * @Serializer\SerializedName("vatShare")
     * @Serializer\Type("double")
     *
     * @var float;
     */
    private $vatShare;

    /**
     * @Serializer\SerializedName("vatRate")
     * @Serializer\Type("double")
     *
     * @var float;
     */
    private $vatRate;  
  
    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param string $status
     *
     * @return PriceResponse
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return string[]
     */
    public function getStatusMessages()
    {
        return $this->statusMessages;
    }

    /**
     * @param string[] $statusMessages
     *
     * @return PriceResponse
     */
    public function setStatusMessages($statusMessages)
    {
        $this->statusMessages = $statusMessages;

        return $this;
    }

    /**
     * @return int
     */
    public function getAmount()
    {
        return $this->amount;
    }

    /**
     * @param int $amount
     *
     * @return PriceResponse
     */
    public function setAmount($amount)
    {
        $this->amount = $amount;

        return $this;
    }

    /**
     * @return string
     */
    public function getArticleNumberId()
    {
        return $this->articleNumberId;
    }

    /**
     * @param string $articleNumberId
     *
     * @return PriceResponse
     */
    public function setArticleNumberId($articleNumberId)
    {
        $this->articleNumberId = $articleNumberId;

        return $this;
    }

    /**
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }

    /**
     * @param string $currency
     *
     * @return PriceResponse
     */
    public function setCurrency($currency)
    {
        $this->currency = $currency;

        return $this;
    }

    /**
     * @return string
     */
    public function getProductGroupId()
    {
        return $this->productGroupId;
    }

    /**
     * @param string $productGroupId
     *
     * @return PriceResponse
     */
    public function setProductGroupId($productGroupId)
    {
        $this->productGroupId = $productGroupId;

        return $this;
    }

    /**
     * @return float
     */
    public function getCurrentPrice()
    {
        return $this->currentPrice;
    }

    /**
     * @param float $currentPrice
     *
     * @return PriceResponse
     */
    public function setCurrentPrice($currentPrice)
    {
        $this->currentPrice = $currentPrice;

        return $this;
    }

    /**
     * @return float
     */
    public function getOriginalPrice()
    {
        return $this->originalPrice;
    }

    /**
     * @param float $originalPrice
     *
     * @return PriceResponse
     */
    public function setOriginalPrice($originalPrice)
    {
        $this->originalPrice = $originalPrice;

        return $this;
    }

    /**
     * @return boolean
     */
    public function getIsSpecialPrice()
    {
        return $this->isSpecialPrice;
    }

    /**
     * @param boolean $isSpecialPrice
     *
     * @return PriceResponse
     */
    public function setIsSpecialPrice($isSpecialPrice)
    {
        $this->isSpecialPrice = $isSpecialPrice;

        return $this;
    }
  
    /**
     * @return float
     */
    public function getCurrentPriceNet()
    {
        return $this->currentPriceNet;
    }

    /**
     * @param float $currentPriceNet
     *
     * @return PriceResponse
     */
    public function setCurrentPriceNet($currentPriceNet)
    {
        $this->currentPriceNet = $currentPriceNet;

        return $this;
    }

    /**
     * @return float
     */
    public function getVatShare()
    {
        return $this->vatShare;
    }

    /**
     * @param float $vatShare
     *
     * @return PriceResponse
     */
    public function setVatShare($vatShare)
    {
        $this->vatShare = $vatShare;

        return $this;
    }

    /**
     * @return float
     */
    public function getVatRate()
    {
        return $this->vatRate;
    }

    /**
     * @param float $vatRate
     *
     * @return PriceResponse
     */
    public function setVatRate($vatRate)
    {
        $this->vatRate = $vatRate;

        return $this;
    }  
}
