<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Model\Xml\Item;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Item
 *
 * @package Stylefile\DataTransfer\Erp2Web\ArticleTransferBundle\XmlModel\Consumer\Item
 *
 * @Serializer\XmlRoot("Item")
 * @Serializer\ExclusionPolicy("all")
 */
class Item
{

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ItemCode")
     * @Serializer\Type("string")
     *
     */
    private $itemCode;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("QtyStock")
     * @Serializer\Type("integer")
     *
     */
    private $qtyStock;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("QtySalesOrder")
     * @Serializer\Type("integer")
     *
     */
    private $qtySalesOrder;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("QtySalesOrderQuar")
     * @Serializer\Type("integer")
     *
     */
    private $qtySalesOrderQuar;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("QtyPreOrder")
     * @Serializer\Type("integer")
     *
     */
    private $qtyPreOrder;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("")
     * @Serializer\Type("integer")
     *
     */
    private $qtyPurchaseOrder;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("RealQty")
     * @Serializer\Type("integer")
     *
     */
    private $realQty;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("QuantityOnStock")
     * @Serializer\Type("integer")
     *
     */
    private $quantityOnStock;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("IsOrderable")
     * @Serializer\Type("integer")
     *
     */
    private $isOrderable;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ShippingState")
     * @Serializer\Type("integer")
     *
     */
    private $shippingState;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ShippingDate")
     * @Serializer\Type("string")
     *
     */
    private $shippingDate;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ShippingDateCalculated")
     * @Serializer\Type("string")
     *
     */
    private $shippingDateCalculated;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Sales90Days")
     * @Serializer\Type("integer")
     *
     */
    private $sales90Days;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Sales30Days")
     * @Serializer\Type("integer")
     *
     */
    private $sales30Days;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Sales90DaysAll")
     * @Serializer\Type("integer")
     *
     */
    private $sales90DaysAll;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Sales30DaysAll")
     * @Serializer\Type("integer")
     *
     */
    private $sales30DaysAll;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Sales60DaysGross")
     * @Serializer\Type("integer")
     *
     */
    private $sales60DaysGross;


    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("SalesTotalGross")
     * @Serializer\Type("integer")
     *
     */
    private $salesTotalGross;

    /**
     * @var \Publikat\Model\Xml\Item\Sales30DaysAmazon
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Sales30DaysAmazon")
     * @Serializer\Type("Stylefile\DataTransfer\Erp2Web\ArticleTransferBundle\XmlModel\Consumer\Item\Sales30DaysAmazon")
     *
     */
    private $sales30DaysAmazon;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Sales30DaysWeare")
     * @Serializer\Type("integer")
     */
    private $sales30DaysWeare;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("QtyReturns60Days")
     * @Serializer\Type("integer")
     *
     */
    private $qtyReturns60Days;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("QtyReturnsTotal")
     * @Serializer\Type("integer")
     *
     */
    private $qtyReturnsTotal;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Reservations")
     * @Serializer\Type("integer")
     *
     */
    private $reservations;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("MinInventory")
     * @Serializer\Type("integer")
     *
     */
    private $minInventory;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("MaxInventory")
     * @Serializer\Type("integer")
     *
     */
    private $maxInventory;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("DynRange1")
     * @Serializer\Type("integer")
     *
     */
    private $dynRange1;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("DynRange2")
     * @Serializer\Type("integer")
     *
     */
    private $dynRange2;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("DynPeriod")
     * @Serializer\Type("integer")
     *
     */
    private $dynPeriod;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Dyn")
     * @Serializer\Type("string")
     *
     */
    private $dyn;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("RestockPolicy")
     * @Serializer\Type("string")
     *
     */
    private $restockPolicy;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("PurchaseOrderDate")
     * @Serializer\Type("string")
     *
     */
    private $purchaseOrderDate;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("LastSale")
     * @Serializer\Type("string")
     *
     */
    private $lastSale;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("LastPurchase")
     * @Serializer\Type("string")
     *
     */
    private $lastPurchase;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("AvailabilityDate")
     * @Serializer\Type("string")
     *
     */
    private $availabilityDate;


    /**
     * @return string
     */
    public function getItemCode()
    {

        return $this->itemCode;
    }

    /**
     * @return int
     */
    public function getQtyStock()
    {

        return $this->qtyStock;
    }

    /**
     * @return int
     */
    public function getQtySalesOrder()
    {

        return $this->qtySalesOrder;
    }

    /**
     * @return int
     */
    public function getQtySalesOrderQuar()
    {

        return $this->qtySalesOrderQuar;
    }

    /**
     * @return int
     */
    public function getQtyPreOrder()
    {

        return $this->qtyPreOrder;
    }

    /**
     * @return int
     */
    public function getQtyPurchaseOrder()
    {

        return $this->qtyPurchaseOrder;
    }

    /**
     * @return int
     */
    public function getRealQty()
    {

        return $this->realQty;
    }

    /**
     * @return int
     */
    public function getQuantityOnStock()
    {

        return $this->quantityOnStock;
    }

    /**
     * @return int
     */
    public function getIsOrderable()
    {

        return $this->isOrderable;
    }

    /**
     * @return int
     */
    public function getShippingState()
    {

        return $this->shippingState;
    }

    /**
     * @return string
     */
    public function getShippingDate()
    {

        return $this->shippingDate;
    }

    /**
     * @return string
     */
    public function getShippingDateCalculated()
    {

        return $this->shippingDateCalculated;
    }

    /**
     * @return int
     */
    public function getSales90Days()
    {

        return $this->sales90Days;
    }

    /**
     * @return int
     */
    public function getSales30Days()
    {

        return $this->sales30Days;
    }

    /**
     * @return int
     */
    public function getSales90DaysAll()
    {

        return $this->sales90DaysAll;
    }

    /**
     * @return int
     */
    public function getSales30DaysAll()
    {

        return $this->sales30DaysAll;
    }

    /**
     * @return int
     */
    public function getSales60DaysGross()
    {

        return $this->sales60DaysGross;
    }

    /**
     * @return int
     */
    public function getSalesTotalGross()
    {

        return $this->salesTotalGross;
    }

    /**
     * @return Sales30DaysAmazon
     */
    public function getSales30DaysAmazon()
    {

        return $this->sales30DaysAmazon;
    }

    /**
     * @return int
     */
    public function getSales30DaysWeare()
    {

        return $this->sales30DaysWeare;
    }

    /**
     * @return int
     */
    public function getQtyReturns60Days()
    {

        return $this->qtyReturns60Days;
    }

    /**
     * @return int
     */
    public function getQtyReturnsTotal()
    {

        return $this->qtyReturnsTotal;
    }

    /**
     * @return int
     */
    public function getReservations()
    {

        return $this->reservations;
    }

    /**
     * @return int
     */
    public function getMinInventory()
    {

        return $this->minInventory;
    }

    /**
     * @return int
     */
    public function getMaxInventory()
    {

        return $this->maxInventory;
    }

    /**
     * @return int
     */
    public function getDynRange1()
    {

        return $this->dynRange1;
    }

    /**
     * @return int
     */
    public function getDynRange2()
    {

        return $this->dynRange2;
    }

    /**
     * @return int
     */
    public function getDynPeriod()
    {

        return $this->dynPeriod;
    }

    /**
     * @return string
     */
    public function getDyn()
    {

        return $this->dyn;
    }

    /**
     * @return string
     */
    public function getRestockPolicy()
    {

        return $this->restockPolicy;
    }

    /**
     * @return string
     */
    public function getPurchaseOrderDate()
    {

        return $this->purchaseOrderDate;
    }

    /**
     * @return string
     */
    public function getLastSale()
    {

        return $this->lastSale;
    }

    /**
     * @return string
     */
    public function getLastPurchase()
    {

        return $this->lastPurchase;
    }

    /**
     * @return string
     */
    public function getAvailabilityDate()
    {

        return $this->availabilityDate;
    }
}
