<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Model\Xml\Item;

use JMS\Serializer\Annotation as Serializer;

/**
 * ItemTransfer
 *
 * @Serializer\XmlRoot("ItemTransfer")
 * @Serializer\ExclusionPolicy("all")
 */
class ItemTransfer
{

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("TransferId")
     * @Serializer\Type("integer")
     *
     */
    private $transferId;


    /**
     * @var \Publikat\Model\Xml\Item\Availability
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Availability")
     * @Serializer\Type("Stylefile\DataTransfer\Erp2Web\ArticleTransferBundle\XmlModel\Consumer\Item\Availability")
     *
     */
    private $availability;


    /**
     * @return int
     */
    public function getTransferId()
    {

        return $this->transferId;
    }

    /**
     * @param int $transferId
     */
    public function setTransferId($transferId)
    {

        $this->transferId = $transferId;
    }

    /**
     * @return Availability
     */
    public function getAvailability()
    {

        return $this->availability;
    }

    /**
     * @param Availability $availability
     */
    public function setAvailability($availability)
    {

        $this->availability = $availability;
    }

    public function getId()
    {

        return $this->transferId;
    }

    public function getLogData()
    {

        return $this->availability->getPgc() . ': available ' . $this->availability->getIsAvailable() . '; shipping state ' . $this->availability->getShippingState();
    }
}
