<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Model\Xml\Price;

use JMS\Serializer\Annotation as Serializer;
use Publikat\Model\Xml\ModelInterface;

/**
 * PriceTransfer
 *
 * @Serializer\XmlRoot("PriceTransfer")
 * @Serializer\ExclusionPolicy("all")
 */
class PriceTransfer implements ModelInterface
{

    /**
     * @var \Publikat\Model\Xml\Price\Price
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Price_ShopID")
     * @Serializer\Type("Publikat\Model\Xml\Price\Price")
     *
     */
    private $price;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("NavInsertTime")
     * @Serializer\Type("string")
     */
    private $navInsertTime;
    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("TransferId")
     * @Serializer\Type("integer")
     */
    private $transferId;

    /**
     * @return int
     */
    public function getId()
    {

        return $this->getPrice()->getProductGroup() . '_' . $this->getPrice()->getArticleNumber();
    }

    /**
     * @return string
     */
    public function getLogData()
    {

        return print_r($this, true);
    }

    /**
     * @return Price
     */
    public function getPrice()
    {
        return $this->price;
    }

    /**
     * @param Price $price
     * @return PriceTransfer
     */
    public function setPrice($price)
    {
        $this->price = $price;
        return $this;
    }

    /**
     * @return string
     */
    public function getNavInsertTime()
    {
        return $this->navInsertTime;
    }

    /**
     * @param string $navInsertTime
     * @return PriceTransfer
     */
    public function setNavInsertTime($navInsertTime)
    {
        $this->navInsertTime = $navInsertTime;
        return $this;
    }

    /**
     * @return int
     */
    public function getTransferId()
    {
        return $this->transferId;
    }

    /**
     * @param int $transferId
     * @return PriceTransfer
     */
    public function setTransferId($transferId)
    {
        $this->transferId = $transferId;
        return $this;
    }
}
