<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Model\Xml\Item;

use JMS\Serializer\Annotation as Serializer;

/**
 * Sales30DaysAmazon
 *
 * @Serializer\XmlRoot("Sales30DaysAmazon")
 * @Serializer\ExclusionPolicy("all")
 */
class Sales30DaysAmazon
{

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("DE")
     * @Serializer\Type("integer")
     *
     */
    private $de;
    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ES")
     * @Serializer\Type("integer")
     *
     */
    private $es;
    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("FR")
     * @Serializer\Type("integer")
     *
     */
    private $fr;
    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("IT")
     * @Serializer\Type("integer")
     *
     */
    private $it;
    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("summary")
     * @Serializer\Type("integer")
     *
     */
    private $summary;

    /**
     * @return int
     */
    public function getDe()
    {

        return $this->de;
    }

    /**
     * @return int
     */
    public function getEs()
    {

        return $this->es;
    }

    /**
     * @return int
     */
    public function getFr()
    {

        return $this->fr;
    }

    /**
     * @return int
     */
    public function getIt()
    {

        return $this->it;
    }

    /**
     * @return int
     */
    public function getSummary()
    {

        return $this->summary;
    }
}
