<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Model\Xml\Discount\ProductDiscountGroup;

use JMS\Serializer\Annotation as Serializer;
use Publikat\Model\Xml\ItemList;

/**
 * ProductDiscountGroup
 *
 * @Serializer\XmlRoot("ProductDiscountGroup")
 * @Serializer\ExclusionPolicy("all")
 */
class ProductDiscountGroup
{

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ProductGroupCode")
     * @Serializer\Type("string")
     *
     */
    private $productGroupCode;

    /**
     * @var ItemList
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("List")
     * @Serializer\Type("Publikat\Model\Xml\ItemList")
     *
     */
    private $productDiscountGroups;

    /**
     * @var boolean
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Delete")
     * @Serializer\Type("boolean")
     *
     */
    private $delete;

    /**
     * @return string
     */
    public function getProductGroupCode()
    {
        return $this->productGroupCode;
    }

    /**
     * @param string $productGroupCode
     * @return ProductDiscountGroup
     */
    public function setProductGroupCode($productGroupCode)
    {
        $this->productGroupCode = $productGroupCode;
        return $this;
    }

    /**
     * @return ItemList
     */
    public function getProductDiscountGroups()
    {
        return $this->productDiscountGroups;
    }

    /**
     * @param ItemList $productDiscountGroups
     * @return ProductDiscountGroup
     */
    public function setProductDiscountGroups($productDiscountGroups)
    {
        $this->productDiscountGroups = $productDiscountGroups;
        return $this;
    }

    /**
     * @return bool
     */
    public function isDelete()
    {
        return $this->delete;
    }

    /**
     * @param bool $delete
     * @return ProductDiscountGroup
     */
    public function setDelete($delete)
    {
        $this->delete = $delete;
        return $this;
    }


}
