<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Model\Xml\Price;

use JMS\Serializer\Annotation as Serializer;

/**
 * Price
 *
 * @Serializer\XmlRoot("Price")
 * @Serializer\ExclusionPolicy("all")
 */
class Price
{

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ProductGroupCode")
     * @Serializer\Type("string")
     *
     */
    private $productGroup;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("ItemCode")
     * @Serializer\Type("string")
     *
     */
    private $articleNumber;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("SystemId")
     * @Serializer\Type("integer")
     *
     */
    private $systemId;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Delete")
     * @Serializer\Type("boolean")
     *
     */
    private $delete;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Currency")
     * @Serializer\Type("string")
     *
     */
    private $currency;

    /**
     * @var float
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("UnitPrice")
     * @Serializer\Type("double")
     *
     */
    private $currentPrice;

    /**
     * @var float
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("OriginalUnitPrice")
     * @Serializer\Type("double")
     *
     */
    private $originalPrice;

    /**
     * @var bool
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("IsSpecialOffer")
     * @Serializer\Type("boolean")
     *
     */
    private $specialPrice;

    /**
     * @var integer
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Type")
     * @Serializer\Type("integer")
     *
     */
    private $priceType;

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Sender")
     * @Serializer\Type("string")
     *
     */
    private $priceSender = '';

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Rule")
     * @Serializer\Type("string")
     *
     */
    private $priceRule = '';

    /**
     * @var string
     *
     * @Serializer\Expose
     * @Serializer\SerializedName("Time")
     * @Serializer\Type("string")
     *
     */
    private $priceTime = '';

    /**
     * @return string
     */
    public function getProductGroup()
    {
        return $this->productGroup;
    }

    /**
     * @param string $productGroup
     * @return Price
     */
    public function setProductGroup($productGroup)
    {
        $this->productGroup = $productGroup;
        return $this;
    }

    /**
     * @return float
     */
    public function getArticleNumber()
    {
        return $this->articleNumber;
    }

    /**
     * @param float $articleNumber
     * @return Price
     */
    public function setArticleNumber($articleNumber)
    {
        $this->articleNumber = $articleNumber;
        return $this;
    }

    /**
     * @return string
     */
    public function getSystemId()
    {
        return $this->systemId;
    }

    /**
     * @param string $systemId
     * @return Price
     */
    public function setSystemId($systemId)
    {
        $this->systemId = $systemId;
        return $this;
    }

    /**
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }

    /**
     * @param string $currency
     * @return Price
     */
    public function setCurrency($currency)
    {
        $this->currency = $currency;
        return $this;
    }

    /**
     * @return float
     */
    public function getCurrentPrice()
    {
        return $this->currentPrice;
    }

    /**
     * @param float $currentPrice
     * @return Price
     */
    public function setCurrentPrice($currentPrice)
    {
        $this->currentPrice = $currentPrice;
        return $this;
    }

    /**
     * @return float
     */
    public function getOriginalPrice()
    {
        return $this->originalPrice;
    }

    /**
     * @param float $originalPrice
     * @return Price
     */
    public function setOriginalPrice($originalPrice)
    {
        $this->originalPrice = $originalPrice;
        return $this;
    }

    /**
     * @return bool
     */
    public function isSpecialPrice()
    {
        return $this->specialPrice;
    }

    /**
     * @param bool $specialPrice
     * @return Price
     */
    public function setSpecialPrice($specialPrice)
    {
        $this->specialPrice = $specialPrice;
        return $this;
    }

    /**
     * @return int
     */
    public function getPriceType()
    {
        return $this->priceType;
    }

    /**
     * @param int $priceType
     * @return Price
     */
    public function setPriceType($priceType)
    {
        $this->priceType = $priceType;
        return $this;
    }

    /**
     * @return string
     */
    public function getDelete()
    {
        return $this->delete;
    }

    /**
     * @param boolean $delete
     * @return Price
     */
    public function setDelete($delete)
    {
        $this->delete = $delete;
        return $this;
    }

    /**
     * @return string
     */
    public function getPriceSender()
    {
        return $this->priceSender;
    }

    /**
     * @param string $priceSender
     * @return Price
     */
    public function setPriceSender($priceSender)
    {
        $this->priceSender = $priceSender;
        return $this;
    }

    /**
     * @return string
     */
    public function getPriceRule()
    {
        return $this->priceRule;
    }

    /**
     * @param string $priceRule
     * @return Price
     */
    public function setPriceRule($priceRule)
    {
        $this->priceRule = $priceRule;
        return $this;
    }

    /**
     * @return string
     */
    public function getPriceTime()
    {
        return $this->priceTime;
    }

    /**
     * @param string $priceTime
     * @return Price
     */
    public function setPriceTime($priceTime)
    {
        $this->priceTime = $priceTime;
        return $this;
    }
}
